//
//  LocatorViewController.m
//  Locator
//
//  Created by Daniel Fajardo on 1/28/14.
//  Copyright (c) 2014 Daniel Fajardo. All rights reserved.
//

#import "LocatorViewController.h"
@interface MyViewController ()
@end

@implementation MyViewController
@synthesize addLat;
@synthesize addLong;

- (void)viewDidLoad
{
    [super viewDidLoad];
    [[LocationHandler getSharedInstance]setDelegate:self];
    [[LocationHandler getSharedInstance]startUpdating];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
-(void)didUpdateToLocation:(CLLocation *)newLocation
              fromLocation:(CLLocation *)oldLocation{
    [latitudeLabel setText:[NSString stringWithFormat:
                            @"Latitude: %f",newLocation.coordinate.latitude]];
    [longitudeLabel setText:[NSString stringWithFormat:
                             @"Longitude: %f",newLocation.coordinate.longitude]];
}

- (IBAction) saveData
{
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
	// get documents path
	NSString *documentsPath = [paths objectAtIndex:0];
	// get the path to our Data/plist file
	NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"Data.plist"];
	
	// check to see if Data.plist exists in documents
	if (![[NSFileManager defaultManager] fileExistsAtPath:plistPath])
	{
		// if not in documents, get property list from main bundle
		plistPath = [[NSBundle mainBundle] pathForResource:@"Data" ofType:@"plist"];
	}
	
	// read property list into memory as an NSData object
	NSData *plistXML = [[NSFileManager defaultManager] contentsAtPath:plistPath];
	NSString *errorDesc = nil;
	NSPropertyListFormat format;
	// convert static property liost into dictionary object
	NSDictionary *temp = (NSDictionary *)[NSPropertyListSerialization propertyListFromData:plistXML mutabilityOption:NSPropertyListMutableContainersAndLeaves format:&format errorDescription:&errorDesc];
	if (!temp)
	{
		NSLog(@"Error reading plist: %@, format: %lu", errorDesc, format);
	}
	// assign values
	self.addLat = [temp objectForKey:@"Lattitude"];
	self.addLong = [temp objectForKey:@"Lattitude"];
	   
	
	// verify the variable added
	latitudeLabel.text = addLat;
	longitudeLabel.text = addLong;
    
    NSString* myLatString = [NSString stringWithFormat:@"%@", addLat];
    NSString* latLabel = [latitudeLabel.text stringByAppendingString:myLatString];
    NSString* myLongString = [NSString stringWithFormat:@"%@", addLong];
    NSString* LongLabel = [longitudeLabel.text stringByAppendingString:myLongString];
    
	// create dictionary with values in UITextFields
    NSDictionary *plistDict = [NSDictionary dictionaryWithObjects: [NSArray arrayWithObjects: latLabel, LongLabel, nil] forKeys:[NSArray arrayWithObjects: @"Lattitude", @"Longitude", nil]];
    
    
    //So for the homework, you will append the above data to the the plist Dictionary below
	
	NSString *error = nil;
	// create NSData from dictionary
    NSData *plistData = [NSPropertyListSerialization dataFromPropertyList:plistDict format:NSPropertyListXMLFormat_v1_0 errorDescription:&error];
	
    // check is plistData exists
	if(plistData)
	{
		// write plistData to our Data.plist file
        [plistData writeToFile:plistPath atomically:YES];
        
        
    }
    else
	{
        NSLog(@"Error in saveData: %@", error);
        [error release];
    }
}


@end
